/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockout.Loader;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.ButtonHandler;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.blockout.views.OverlayView;
import com.ldtteam.blockout.views.View;
import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.util.Log;
import java.util.List;
import java.util.function.ObjIntConsumer;
import net.minecraft.util.text.IFormattableTextComponent;

public class DialogDoneCancel
extends OverlayView
implements ButtonHandler {
    public static final int CANCEL = 0;
    public static final int DONE = 1;
    private static final String DIALOG_OK_CANCEL_SUFFIX = ":gui/dialogdonecancel.xml";
    protected final Text titleLabel;
    protected final Text contentText;
    protected final Button doneButton;
    protected final Button cancelButton;
    protected ObjIntConsumer<DialogDoneCancel> handler;

    public DialogDoneCancel(Window window) {
        Loader.createFromXMLFile((String)"minecolonies:gui/dialogdonecancel.xml", (View)this);
        this.titleLabel = (Text)this.findPaneOfTypeByID("title", Text.class);
        this.contentText = (Text)this.findPaneOfTypeByID("textcontent", Text.class);
        this.doneButton = (Button)this.findPaneOfTypeByID("done", Button.class);
        this.cancelButton = (Button)this.findPaneOfTypeByID("cancel", Button.class);
        this.doneButton.setHandler((ButtonHandler)this);
        this.cancelButton.setHandler((ButtonHandler)this);
        this.window = window;
    }

    public String getTitle() {
        return this.titleLabel.getTextAsString();
    }

    public void setTitle(String title) {
        this.titleLabel.setText(title);
    }

    public List<IFormattableTextComponent> getTextContent() {
        return this.contentText.getTextAsList();
    }

    public void setTextContent(String content) {
        this.contentText.setText(content);
    }

    public void onButtonClicked(Button button) {
        this.setVisible(false);
        if (this.handler == null) {
            Log.getLogger().error("DialogDoneCancel does not have a handler.");
            return;
        }
        if (button == this.doneButton) {
            this.handler.accept(this, 1);
        } else {
            this.handler.accept(this, 0);
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.setPosition(0, 0);
            this.setSize(this.window.getInteriorWidth(), this.window.getInteriorHeight());
            this.putInside((View)this.window);
        }
        super.setVisible(visible);
    }

    public void open() {
        this.setVisible(true);
    }

    public void close() {
        this.setVisible(true);
    }

    public void setHandler(ObjIntConsumer<DialogDoneCancel> h) {
        this.handler = h;
    }
}

